# 💧 Pianificazione Acquedotto

App di pianificazione settimanale per team - Versione SQLite

## 📁 Struttura

```
pianificazione-app/
├── main.py           # Backend FastAPI + Admin Panel
├── database.py       # Gestione SQLite
├── index.html        # Frontend React
├── requirements.txt  # Dipendenze Python
├── Dockerfile        # Container image
├── docker-compose.yml
└── README.md
```

## 🚀 Avvio Rapido con Docker

```bash
# 1. Build e avvio
docker-compose up -d --build

# 2. Verifica
docker-compose logs -f
```

L'app sarà disponibile su:
- **Frontend**: http://localhost:8000/app
- **Admin Panel**: http://localhost:8000/admin
- **API**: http://localhost:8000/api/

## 🔐 Credenziali di Default

| Utente | ID | Password | Ruolo |
|--------|-----|----------|-------|
| Marco Rossi | `marco` | `admin123` | **Superuser** |
| Luigi Bianchi | `luigi` | `pass123` | Manager |
| Anna Verdi | `anna` | `pass123` | Manager |

⚠️ **Cambia le password dopo il primo accesso!**

## 🖥️ Avvio Locale (senza Docker)

```bash
# 1. Installa dipendenze
pip install -r requirements.txt

# 2. Avvia server
python main.py
```

## 📊 Database

Il database SQLite (`planning.db`) viene creato automaticamente al primo avvio.

**Tabelle:**
- `managers` - Utenti/responsabili
- `team_assignments` - Persone assegnate ai team
- `planning` - Pianificazione settimanale
- `daily_notes` - Note giornaliere

**Backup:**
```bash
# Copia il file database
docker cp pianificazione-acquedotto:/data/planning.db ./backup_$(date +%Y%m%d).db
```

## ⚙️ Pannello Admin

Accessibile da `/admin` - **Solo superuser**

Funzionalità:
- ✅ Gestione Manager (CRUD)
- ✅ Gestione Persone/Team
- ✅ Visualizza Planning
- ✅ Visualizza/Elimina Note

## 🌐 Deploy su VPS con Caddy

Aggiungi al tuo Caddyfile:

```
planner.tuodominio.it {
    reverse_proxy localhost:8000
}
```

## 📱 Note

- L'app è responsive (desktop + mobile)
- Il frontend NON è cambiato, usa lo stesso React
- L'API è compatibile al 100% con la versione Baserow
